/*==============================================================================
IC - Canada - interprovincial migration

Outline:
This do file brings in provincial level data on interprovincial migration

Table 051-0004 Components of population growth, Canada, provinces and territories, annual (persons)

==============================================================================*/

clear all
set more off

cd "$insheet_files/Canada"

insheet using CA_cansim_migration.csv

gen j=.
replace j=1 if comp=="Births (4,17)"
replace j=2 if comp=="Deaths (5,18)"
replace j=3 if comp=="Emigrants (13)"
replace j=4 if comp=="Immigrants (6)"
replace j=5 if comp=="Net interprovincial migration (9)"
replace j=6 if comp=="Net non-permanent residents (10,11,16)"
replace j=7 if comp=="Net temporary emigrants (15)"
replace j=8 if comp=="Residual deviation (12)"
replace j=9 if comp=="Returning emigrants (14)"

drop component 

reshape wide v, i(geo) j(j) 

drop if v31==. & v32==. & v35==.
keep geo v31 v32 v35

rename v31 birth_number
rename v32 death_number
rename v35 net_interprovincial_migration

gen provca=.
replace provca=1 if geo=="Newfoundland and Labrador"
replace provca=2 if geo=="Prince Edward Island"
replace provca=3 if geo=="Nova Scotia"
replace provca=4 if geo=="New Brunswick"
replace provca=5 if geo=="Quebec"
replace provca=6 if geo=="Ontario"
replace provca=7 if geo=="Manitoba"
replace provca=8 if geo=="Saskatchewan"
replace provca=9 if geo=="Alberta"
replace provca=10 if geo=="British Columbia"
replace provca=11 if geo=="Northwest Territories including Nunavut (2)"
replace provca=11 if geo=="Yukon"

drop if provca==11 
keep provca net_ 

tempfile net_migration
save	`net_migration.dta'

use provca inmigration using "$dta_files/IC_CA_CENS1971.dta", clear

merge 1:1 provca using `net_migration.dta', nogen

**Create annualized migration variables
replace inmigration = inmigration/3.31 //This is the ratio of 5 yr to 1 yr flows
* for Canada in the early eighties and comes from Rogers, Raymer and Newbold (2003)

gen outmigration = inmigration - net_interprovincial  if inmigration!=0

gen migration_yrs=1 

********************************************************************************
gen region=1 if provca==0

replace region= 124001 if provca ==2
replace region= 124002 if provca ==3
replace region= 124003 if provca ==4
replace region= 124004 if provca ==5
replace region= 124005 if provca ==6
replace region= 124006 if provca ==7
replace region= 124007 if provca ==8 
replace region= 124008 if provca ==9
replace region= 124009 if provca ==10
replace region= 124010 if provca ==1

gen nuts=""
replace nuts = "Canada" if region ==1
replace nuts = "CA: Prince Edward Island" if region == 124001
replace nuts =  "CA: Nova Scotia"  if region ==  124002
replace nuts =  "CA: New Brunswick"  if region == 124003
replace nuts =  "CA: Quebec"  if region == 124004
replace nuts =  "CA: Ontario"  if region ==  124005
replace nuts =  "CA: Manitoba"  if region ==  124006
replace nuts =  "CA: Saskatchewan"  if region ==  124007
replace nuts =  "CA: Alberta" if region ==  124008
replace nuts =  "CA: British Columbia"  if region == 124009
replace nuts =  "CA: Newfoundland and Labrador"  if region == 124010
********************************************************************************

drop net
drop if inmigration==. 
save "$dta_files/IC_CA_migration.dta", replace
